/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.TreeSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class SphinxAmbassadorEffect
extends OneShotEffect {
    SphinxAmbassadorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "search that player's library for a card, then that player chooses a card name. If you searched for a creature card that doesn't have that name, you may put it onto the battlefield under your control. Then that player shuffles";
    }

    private SphinxAmbassadorEffect(SphinxAmbassadorEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxAmbassadorEffect copy() {
        return new SphinxAmbassadorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && targetPlayer != null && sourcePermanent != null) {
            TargetCardInLibrary target = new TargetCardInLibrary();
            controller.searchLibrary(target, source, game, targetPlayer.getId());
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                TreeSet<String> choices = new TreeSet<String>();
                Collection cards = game.getCards();
                for (Card gameCard : cards) {
                    if (!gameCard.isOwnedBy(targetPlayer.getId())) continue;
                    choices.add(gameCard.getName());
                }
                ChoiceImpl cardChoice = new ChoiceImpl(false, ChoiceHintType.CARD);
                cardChoice.setChoices(choices);
                cardChoice.clearChoice();
                if (!targetPlayer.choose(Outcome.Benefit, (Choice)cardChoice, game)) {
                    return false;
                }
                String cardName = cardChoice.getChoice();
                game.informPlayers(sourcePermanent.getName() + ", named card: [" + cardName + ']');
                if (!card.getName().equals(cardName) && card.isCreature(game) && controller.chooseUse(this.outcome, "Put " + card.getName() + " onto the battlefield?", source, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            targetPlayer.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

