/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlashbackAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class SphinxOfForgottenLoreEffect
extends ContinuousEffectImpl {
    SphinxOfForgottenLoreEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "target instant or sorcery card in your graveyard gains flashback until end of turn. The flashback cost is equal to that card's mana cost";
    }

    private SphinxOfForgottenLoreEffect(SphinxOfForgottenLoreEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SphinxOfForgottenLoreEffect copy() {
        return new SphinxOfForgottenLoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            FlashbackAbility ability = new FlashbackAbility(card, (Cost)card.getManaCost());
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
            return true;
        }
        return false;
    }
}

