/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SphinxSovereignEffect
extends OneShotEffect {
    SphinxSovereignEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain 3 life if {this} is untapped. Otherwise, each opponent loses 3 life";
    }

    private SphinxSovereignEffect(SphinxSovereignEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxSovereignEffect copy() {
        return new SphinxSovereignEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)source.getSourceObject(game);
        if (controller != null && permanent != null) {
            if (!permanent.isTapped()) {
                controller.gainLife(3, game, source);
            } else {
                for (UUID opponentId : game.getState().getPlayersInRange(controller.getId(), game)) {
                    Player opponent;
                    if (!controller.hasOpponent(opponentId, game) || (opponent = game.getPlayer(opponentId)) == null) continue;
                    opponent.loseLife(3, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

