/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SphinxsTutelageEffect
extends OneShotEffect {
    SphinxsTutelageEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent mills two cards. If two nonland cards that share a color were milled this way, repeat this process.";
    }

    private SphinxsTutelageEffect(SphinxsTutelageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SphinxsTutelageEffect copy() {
        return new SphinxsTutelageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null) {
            boolean colorShared;
            int possibleIterations = targetPlayer.getLibrary().size() / 2;
            int iteration = 0;
            do {
                if (++iteration > possibleIterations + 20) {
                    game.setDraw(source.getControllerId());
                    return true;
                }
                colorShared = false;
                List cards = targetPlayer.millCards(2, source, game).getCards(game).stream().filter(card -> !card.isLand(game)).collect(Collectors.toList());
                if (cards.size() < 2) break;
                block1: for (int i = 0; i < cards.size() && !colorShared; ++i) {
                    ObjectColor color1 = ((Card)cards.get(i)).getColor(game);
                    if (color1.isColorless()) continue;
                    for (int j = 0; j < cards.size(); ++j) {
                        ObjectColor color2;
                        if (i >= j || !color1.shares(color2 = ((Card)cards.get(j)).getColor(game))) continue;
                        colorShared = true;
                        continue block1;
                    }
                }
            } while (colorShared);
            return true;
        }
        return false;
    }
}

