/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SpikeCannibalEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Creatures with +1/+1 counter");

    SpikeCannibalEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "move all +1/+1 counters from all creatures onto it";
    }

    private SpikeCannibalEffect(SpikeCannibalEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpikeCannibalEffect copy() {
        return new SpikeCannibalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int countersRemoved = 0;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                int numberCounters;
                if (Objects.equals(creature, sourcePermanent) || (numberCounters = creature.getCounters(game).getCount(CounterType.P1P1)) <= 0) continue;
                creature.removeCounters(CounterType.P1P1.getName(), numberCounters, source, game);
                countersRemoved += numberCounters;
            }
            if (countersRemoved > 0) {
                sourcePermanent.addCounters(CounterType.P1P1.createInstance(countersRemoved), source.getControllerId(), source, game);
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
    }
}

