/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SpikeshotElderEffect
extends OneShotEffect {
    public SpikeshotElderEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage equal to its power to any target";
    }

    private SpikeshotElderEffect(SpikeshotElderEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (sourcePermanent == null) {
            return false;
        }
        int damage = sourcePermanent.getPower().getValue();
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            permanent.damage(damage, sourcePermanent.getId(), source, game, false, true);
            return true;
        }
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            player.damage(damage, sourcePermanent.getId(), source, game);
            return true;
        }
        return false;
    }

    public SpikeshotElderEffect copy() {
        return new SpikeshotElderEffect(this);
    }
}

