/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SpinerockKnollWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfDamageReceivedThisTurn = new HashMap<UUID, Integer>();

    SpinerockKnollWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER) {
            return;
        }
        Integer amount = this.amountOfDamageReceivedThisTurn.compute(event.getPlayerId(), (u, i) -> i == null ? event.getAmount() : Integer.sum(event.getAmount(), i));
    }

    public int getDamageReceived(UUID playerId) {
        return this.amountOfDamageReceivedThisTurn.getOrDefault(playerId, 0);
    }

    public void reset() {
        super.reset();
        this.amountOfDamageReceivedThisTurn.clear();
    }
}

