/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class SpinningDarknessCost
extends CostImpl {
    private static final FilterCard filter = new FilterCard("black card");

    SpinningDarknessCost() {
        this.text = "exile the top three black cards of your graveyard";
    }

    private SpinningDarknessCost(SpinningDarknessCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Set blackCardsInGraveyard;
        int size;
        Player controller = game.getPlayer(controllerId);
        if (controller != null && (size = (blackCardsInGraveyard = controller.getGraveyard().getCards(filter, game)).size()) >= 3) {
            Iterator it = blackCardsInGraveyard.iterator();
            CardsImpl cardsToExile = new CardsImpl();
            int i = 1;
            while (cardsToExile.size() < 3) {
                Card card = (Card)it.next();
                if (i > size - 3) {
                    cardsToExile.add(card);
                }
                ++i;
            }
            this.paid = controller.moveCards((Cards)cardsToExile, Zone.EXILED, ability, game);
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null) {
            return controller.getGraveyard().getCards(filter, game).size() >= 3;
        }
        return false;
    }

    public SpinningDarknessCost copy() {
        return new SpinningDarknessCost(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLACK));
    }
}

