/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SpiritOfTheLabyrinthWatcher
extends Watcher {
    private final Set<UUID> playersThatDrewCard = new HashSet<UUID>();

    public SpiritOfTheLabyrinthWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DREW_CARD) {
            this.playersThatDrewCard.add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.playersThatDrewCard.clear();
    }

    public boolean hasPlayerDrewCardThisTurn(UUID playerId) {
        return this.playersThatDrewCard.contains(playerId);
    }
}

