/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.Card;
import mage.cards.s.SpiritSistersCallReturnToBattlefieldEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCardTypePredicate;
import mage.game.Game;

class SpiritSistersCallDoIfEffect
extends OneShotEffect {
    SpiritSistersCallDoIfEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "choose target permanent card in your graveyard. You may sacrifice a permanent that shares a card type with the chosen card. If you do, return the chosen card from your graveyard to the battlefield and it gains \"If this permanent would leave the battlefield, exile it instead of putting it anywhere else.\"";
    }

    private SpiritSistersCallDoIfEffect(SpiritSistersCallDoIfEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpiritSistersCallDoIfEffect copy() {
        return new SpiritSistersCallDoIfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = source.getFirstTarget();
        Card card = game.getCard(targetId);
        if (card == null || game.getState().getZone(targetId) != Zone.GRAVEYARD) {
            return false;
        }
        SharesCardTypePredicate predicate = new SharesCardTypePredicate((Collection)card.getCardType(game));
        FilterControlledPermanent filter = new FilterControlledPermanent(predicate.toString());
        filter.add((Predicate)predicate);
        return new DoIfCostPaid((Effect)new SpiritSistersCallReturnToBattlefieldEffect(), (Cost)new SacrificeTargetCost((FilterPermanent)filter)).apply(game, source);
    }
}

