/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.s.SpiritualFocusDrawCardEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class SpiritualFocusTriggeredAbility
extends TriggeredAbilityImpl {
    public SpiritualFocusTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(2), false);
        this.addEffect((Effect)new SpiritualFocusDrawCardEffect());
    }

    private SpiritualFocusTriggeredAbility(SpiritualFocusTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SpiritualFocusTriggeredAbility copy() {
        return new SpiritualFocusTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        return stackObject != null && game.getOpponents(this.getControllerId()).contains(stackObject.getControllerId()) && (permanent = game.getPermanent(this.getSourceId())) != null && Objects.equals(permanent.getControllerId(), event.getPlayerId());
    }

    public String getRule() {
        return "Whenever a spell or ability an opponent controls causes you to discard a card, you gain 2 life and you may draw a card.";
    }
}

