/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SpitefulReturnedTriggeredAbility
extends TriggeredAbilityImpl {
    public SpitefulReturnedTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever {this} or enchanted creature attacks, ");
    }

    private SpitefulReturnedTriggeredAbility(SpitefulReturnedTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public SpitefulReturnedTriggeredAbility copy() {
        return new SpitefulReturnedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        if (sourcePermanent.isCreature(game)) {
            if (event.getSourceId() != null && event.getSourceId().equals(this.getSourceId())) {
                UUID defender = game.getCombat().getDefendingPlayerId(this.getSourceId(), game);
                ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defender));
                return true;
            }
        } else if (sourcePermanent.isAttachedTo(event.getSourceId())) {
            UUID defender = game.getCombat().getDefendingPlayerId(sourcePermanent.getAttachedTo(), game);
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defender));
            return true;
        }
        return false;
    }
}

