/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SpittingDilophosaurusRestrictionEffect
extends RestrictionEffect {
    public SpittingDilophosaurusRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures your opponents control with -1/-1 counters on them can't block.";
    }

    private SpittingDilophosaurusRestrictionEffect(SpittingDilophosaurusRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public SpittingDilophosaurusRestrictionEffect copy() {
        return new SpittingDilophosaurusRestrictionEffect(this);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && permanent != null && game.isOpponent(player, permanent.getControllerId())) {
            return permanent.getCounters(game).getCount(CounterType.M1M1) > 0;
        }
        return false;
    }
}

