/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class SplitDecisionEffect
extends OneShotEffect {
    SplitDecisionEffect() {
        super(Outcome.Removal);
        this.staticText = "<i>Will of the council</i> &mdash; Choose target instant or sorcery spell. Starting with you, each player votes for denial or duplication. If denial gets more votes, counter the spell. If duplication gets more votes or the vote is tied, copy the spell. You may choose new targets for the copy";
    }

    private SplitDecisionEffect(SplitDecisionEffect effect) {
        super((OneShotEffect)effect);
    }

    public SplitDecisionEffect copy() {
        return new SplitDecisionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Denial (counter " + spell.getIdName() + ")", "Duplication (copy " + spell.getIdName() + ")", Outcome.Benefit);
        vote.doVotes(source, game);
        int denialCount = vote.getVoteCount((Object)true);
        int duplicationCount = vote.getVoteCount((Object)false);
        if (denialCount > duplicationCount) {
            return game.getStack().counter(spell.getId(), source, game);
        }
        return new CopyTargetStackObjectEffect().apply(game, source);
    }
}

