/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.ManaPaidSourceWatcher;

class SpoilsOfTheHuntEffect
extends OneShotEffect {
    SpoilsOfTheHuntEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature you control gets +1/+0 until end of turn for each mana from a Treasure that was spent to cast this spell";
    }

    private SpoilsOfTheHuntEffect(SpoilsOfTheHuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpoilsOfTheHuntEffect copy() {
        return new SpoilsOfTheHuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int treasurePaid = ManaPaidSourceWatcher.getTreasurePaid((UUID)source.getId(), (Game)game);
        game.addEffect(new BoostTargetEffect(treasurePaid, 0, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game)), source);
        return true;
    }
}

