/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Objects;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SpreadingPlagueEffect
extends OneShotEffect {
    static final FilterPermanent FILTER = new FilterPermanent("creature");

    SpreadingPlagueEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all other creatures that share a color with it. They can't be regenerated";
    }

    private SpreadingPlagueEffect(SpreadingPlagueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature != null) {
            ObjectColor color = creature.getColor(game);
            for (Permanent permanent : game.getBattlefield().getActivePermanents(FILTER, source.getControllerId(), game)) {
                if (!permanent.getColor(game).shares(color) || Objects.equals(permanent, creature)) continue;
                permanent.destroy(source, game, true);
            }
            return true;
        }
        return false;
    }

    public SpreadingPlagueEffect copy() {
        return new SpreadingPlagueEffect(this);
    }

    static {
        FILTER.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

