/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.FaceDownPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SpyNetworkFaceDownEffect
extends OneShotEffect {
    SpyNetworkFaceDownEffect() {
        super(Outcome.Benefit);
        this.staticText = "and any face-down creatures they control";
    }

    private SpyNetworkFaceDownEffect(SpyNetworkFaceDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public SpyNetworkFaceDownEffect copy() {
        return new SpyNetworkFaceDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject mageObject = game.getObject(source);
        if (controller != null && player != null && mageObject != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent("face down creature controlled by " + player.getLogName());
            filter.add((Predicate)FaceDownPredicate.instance);
            filter.add((Predicate)new ControllerIdPredicate(player.getId()));
            TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, true);
            if (target.canChoose(controller.getId(), source, game)) {
                while (controller.chooseUse(this.outcome, "Look at a face down creature controlled by " + player.getLogName() + "?", source, game)) {
                    target.clearChosen();
                    while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                        controller.chooseTarget(this.outcome, (Target)target, source, game);
                    }
                    Permanent faceDownCreature = game.getPermanent(target.getFirstTarget());
                    if (faceDownCreature == null) continue;
                    controller.lookAtCards("face down card - " + mageObject.getName(), (Card)faceDownCreature, game);
                    game.informPlayers(controller.getLogName() + " looks at a face down creature controlled by " + player.getLogName());
                }
            }
            return true;
        }
        return false;
    }
}

