/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class SqueesRevengeEffect
extends OneShotEffect {
    SqueesRevengeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Choose a number. Flip a coin that many times or until you lose a flip, whichever comes first. If you win all the flips, draw two cards for each flip.";
    }

    private SqueesRevengeEffect(SqueesRevengeEffect effect) {
        super((OneShotEffect)effect);
    }

    public SqueesRevengeEffect copy() {
        return new SqueesRevengeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int number = player.getAmount(0, Integer.MAX_VALUE, "Choose how many times to flip a coin", source, game);
            game.informPlayers(player.getLogName() + " chooses " + number + '.');
            for (int i = 0; i < number; ++i) {
                if (player.flipCoin(source, game, true)) continue;
                return true;
            }
            player.drawCards(2 * number, source, game);
            return true;
        }
        return false;
    }
}

