/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.mana.AddManaToManaPoolTargetControllerEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StadiumVendorsEffect
extends OneShotEffect {
    StadiumVendorsEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a player. That player adds two mana of any one color they choose";
    }

    private StadiumVendorsEffect(StadiumVendorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StadiumVendorsEffect copy() {
        return new StadiumVendorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPlayer target = new TargetPlayer(1, 1, true);
        if (controller.choose(Outcome.Benefit, (Target)target, source, game)) {
            Player player = game.getPlayer(target.getFirstTarget());
            ChoiceColor colorChoice = new ChoiceColor(true);
            if (player == null || !player.choose(Outcome.Benefit, (Choice)colorChoice, game)) {
                return false;
            }
            AddManaToManaPoolTargetControllerEffect effect = new AddManaToManaPoolTargetControllerEffect(colorChoice.getMana(2), "that player's");
            effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
            return effect.apply(game, source);
        }
        return false;
    }
}

