/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class StandOrFallEffect
extends OneShotEffect {
    StandOrFallEffect() {
        super(Outcome.Detriment);
        this.staticText = "for each defending player, separate all creatures that player controls into two piles and that player chooses one. Only creatures in the chosen piles can block this turn";
    }

    private StandOrFallEffect(StandOrFallEffect effect) {
        super((OneShotEffect)effect);
    }

    public StandOrFallEffect copy() {
        return new StandOrFallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ArrayList canBlock = new ArrayList();
        for (UUID oppId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(oppId);
            if (opponent == null) continue;
            FilterCreaturePermanent opponentFilter = new FilterCreaturePermanent();
            opponentFilter.add((Predicate)new ControllerIdPredicate(oppId));
            TargetPermanent creatures = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)opponentFilter, true);
            ArrayList<Permanent> pile1 = new ArrayList<Permanent>();
            if (player.choose(Outcome.Neutral, (Target)creatures, source, game)) {
                List targets = creatures.getTargets();
                for (UUID targetId : targets) {
                    Permanent p = game.getPermanent(targetId);
                    if (p == null) continue;
                    pile1.add(p);
                }
            }
            ArrayList<Permanent> pile2 = new ArrayList<Permanent>();
            for (Permanent p : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, opponent.getId(), game)) {
                if (pile1.contains(p)) continue;
                pile2.add(p);
            }
            boolean choice = opponent.choosePile(this.outcome, "Choose which pile can block this turn.", pile1, pile2, game);
            canBlock.addAll(choice ? pile1 : pile2);
        }
        FilterCreaturePermanent filterRestriction = new FilterCreaturePermanent();
        filterRestriction.add(Predicates.not((Predicate)new PermanentReferenceInCollectionPredicate(canBlock, game)));
        game.addEffect((ContinuousEffect)new CantBlockAllEffect(filterRestriction, Duration.EndOfTurn), source);
        game.informPlayers("Creatures that can block this turn: " + canBlock.stream().map(MageObject::getLogName).collect(Collectors.joining(", ")));
        return true;
    }
}

