/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StandstillEffect
extends OneShotEffect {
    StandstillEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice {this}. If you do, each of that player's opponents draws three cards";
    }

    private StandstillEffect(StandstillEffect effect) {
        super((OneShotEffect)effect);
    }

    public StandstillEffect copy() {
        return new StandstillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && permanent.sacrifice(source, game)) {
            for (UUID uuid : game.getOpponents(this.getTargetPointer().getFirst(game, source))) {
                Player player = game.getPlayer(uuid);
                if (player == null) continue;
                player.drawCards(3, source, game);
            }
            return true;
        }
        return false;
    }
}

