/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StarfallEffect
extends OneShotEffect {
    StarfallEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 3 damage to target creature. If that creature is an enchantment, {this} deals 3 damage to that creature's controller";
    }

    private StarfallEffect(StarfallEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarfallEffect copy() {
        return new StarfallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            Player targetController;
            permanent.damage(3, source.getSourceId(), source, game, false, true);
            if (permanent.isEnchantment(game) && (targetController = game.getPlayer(permanent.getControllerId())) != null) {
                targetController.damage(3, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

