/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.s.StarkeOfRathControlEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StarkeOfRathEffect
extends OneShotEffect {
    StarkeOfRathEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact or creature. That permanent's controller gains control of {this}";
    }

    private StarkeOfRathEffect(StarkeOfRathEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarkeOfRathEffect copy() {
        return new StarkeOfRathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetPermanent != null) {
                targetPermanent.destroy(source, game, false);
                StarkeOfRathControlEffect effect = new StarkeOfRathControlEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent.getControllerId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

