/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class StarlightSpectacularEffect
extends OneShotEffect {
    StarlightSpectacularEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose creatures you control one at a time until each creature you control has been chosen. Each of those creatures gets +1/+1 until end of turn for each creature chosen before it. <i>(Places everyone! The first creature in line gets +0/+0.)</i>";
    }

    private StarlightSpectacularEffect(StarlightSpectacularEffect effect) {
        super((OneShotEffect)effect);
    }

    public StarlightSpectacularEffect copy() {
        return new StarlightSpectacularEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game);
        if (count < 1) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(count);
        target.withNotTarget(true);
        target.withChooseHint("the first creature you choose gets +0/+0");
        player.choose(this.outcome, (Target)target, source, game);
        int boost = 0;
        for (UUID targetId : target.getTargets()) {
            if (boost > 0) {
                game.addEffect(new BoostTargetEffect(boost, boost).setTargetPointer((TargetPointer)new FixedTarget(targetId, game)), source);
            }
            ++boost;
        }
        return true;
    }
}

