/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StarlitSanctumWhiteEffect
extends OneShotEffect {
    StarlitSanctumWhiteEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the sacrificed creature's toughness";
    }

    private StarlitSanctumWhiteEffect(StarlitSanctumWhiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        int amount = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost) || ((SacrificeTargetCost)cost).getPermanents().isEmpty()) continue;
            amount = ((Permanent)((SacrificeTargetCost)cost).getPermanents().get(0)).getToughness().getValue();
            break;
        }
        if (amount > 0 && (player = game.getPlayer(source.getControllerId())) != null) {
            player.gainLife(amount, game, source);
            return true;
        }
        return false;
    }

    public StarlitSanctumWhiteEffect copy() {
        return new StarlitSanctumWhiteEffect(this);
    }
}

