/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetLandPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SteamVinesEffect
extends OneShotEffect {
    SteamVinesEffect() {
        super(Outcome.Detriment);
        this.staticText = "destroy it and {this} deals 1 damage to that land's controller. That player attaches {this} to a land of their choice";
    }

    private SteamVinesEffect(SteamVinesEffect effect) {
        super((OneShotEffect)effect);
    }

    public SteamVinesEffect copy() {
        return new SteamVinesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent steamVines = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (steamVines != null) {
            Permanent enchantedLand = game.getPermanentOrLKIBattlefield(steamVines.getAttachedTo());
            Player controller = game.getPlayer(source.getControllerId());
            if (enchantedLand != null && controller != null) {
                Player landsController = game.getPlayer(enchantedLand.getControllerId());
                if (game.getState().getZone(enchantedLand.getId()) == Zone.BATTLEFIELD) {
                    enchantedLand.destroy(source, game, false);
                    if (landsController != null) {
                        landsController.damage(1, source.getSourceId(), source, game);
                    }
                }
                if (game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_LAND, source, game, 1)) {
                    Permanent landChosen;
                    TargetLandPermanent target = new TargetLandPermanent();
                    target.withNotTarget(true);
                    Card steamVinesCard = game.getCard(source.getSourceId());
                    if (steamVinesCard != null && landsController != null && landsController.choose(Outcome.DestroyPermanent, (Target)target, source, game) && target.getFirstTarget() != null && (landChosen = game.getPermanent(target.getFirstTarget())) != null) {
                        for (Target targetTest : steamVinesCard.getSpellAbility().getTargets()) {
                            Filter filterTest = targetTest.getFilter();
                            if (!filterTest.match((Object)landChosen, game) || !game.getBattlefield().containsPermanent(landChosen.getId())) continue;
                            game.informPlayers(landsController.getLogName() + " attaches " + steamVines.getLogName() + " to " + landChosen.getLogName());
                            AttachEffect effect = new AttachEffect(Outcome.Neutral);
                            effect.setTargetPointer((TargetPointer)new FixedTarget(landChosen, game));
                            return effect.apply(game, source);
                        }
                    }
                }
            }
        }
        return false;
    }
}

