/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class SteelHellkiteWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> damageMap = new HashMap<UUID, Set<UUID>>();

    public SteelHellkiteWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedEvent)event).isCombatDamage()) {
            this.damageMap.putIfAbsent(event.getSourceId(), new HashSet());
            this.damageMap.get(event.getSourceId()).add(event.getPlayerId());
        }
    }

    public void reset() {
        super.reset();
        this.damageMap.clear();
    }

    public Set<UUID> getDamagedPlayers(UUID damagerId) {
        return this.damageMap.getOrDefault(damagerId, new HashSet());
    }
}

