/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.s.SteerClearWatcher;
import mage.constants.Outcome;
import mage.game.Game;

class SteerClearEffect
extends OneShotEffect {
    SteerClearEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to target attacking or blocking creature. {this} deals 4 damage to that creature instead if you controlled a Mount as you cast this spell.";
    }

    private SteerClearEffect(SteerClearEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        SteerClearWatcher watcher = (SteerClearWatcher)game.getState().getWatcher(SteerClearWatcher.class);
        if (watcher == null) {
            return false;
        }
        int amount = watcher.didControlMountOnCast(new MageObjectReference(source.getSourceObject(game), game)) ? 4 : 2;
        return new DamageTargetEffect(amount).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
    }

    public SteerClearEffect copy() {
        return new SteerClearEffect(this);
    }
}

