/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class StenchOfEvilEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    public StenchOfEvilEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all Plains. For each land destroyed this way, {this} deals 1 damage to that land's controller unless they pay {2}";
    }

    private StenchOfEvilEffect(StenchOfEvilEffect effect) {
        super((OneShotEffect)effect);
    }

    public StenchOfEvilEffect copy() {
        return new StenchOfEvilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent land : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            UUID landControllerId = land.getControllerId();
            if (!land.destroy(source, game, false)) continue;
            ManaCostsImpl cost = new ManaCostsImpl("{2}");
            Player landController = game.getPlayer(landControllerId);
            if (landController == null || !cost.canPay(source, source, landControllerId, game) || cost.pay(source, game, source, landControllerId, false)) continue;
            landController.damage(1, source.getSourceId(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

