/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StepBetweenWorldsEffect
extends OneShotEffect {
    StepBetweenWorldsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Each player may shuffle their hand and graveyard into their library. Each player who does draws seven cards";
    }

    private StepBetweenWorldsEffect(StepBetweenWorldsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StepBetweenWorldsEffect copy() {
        return new StepBetweenWorldsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(Outcome.Benefit, "Shuffle your hand and graveyard into your library, then draw seven cards?", source, game)) continue;
            players.add(player);
            CardsImpl cards = new CardsImpl((Collection)player.getHand());
            cards.addAll((Collection)player.getGraveyard());
            player.putCardsOnTopOfLibrary((Cards)cards, game, source, false);
            player.shuffleLibrary(source, game);
        }
        for (Player player : players) {
            player.drawCards(7, source, game);
        }
        return true;
    }
}

