/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.turn.TurnMod;
import mage.players.Player;

class StitchInTimeEffect
extends OneShotEffect {
    StitchInTimeEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Flip a coin. If you win the flip, take an extra turn after this one";
    }

    private StitchInTimeEffect(StitchInTimeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.flipCoin(source, game, true)) {
            game.getState().getTurnMods().add(new TurnMod(player.getId()).withExtraTurn());
            return true;
        }
        return false;
    }

    public StitchInTimeEffect copy() {
        return new StitchInTimeEffect(this);
    }
}

