/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.token.StitcherGeralfZombieToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.TargetCard;

class StitcherGeralfEffect
extends OneShotEffect {
    StitcherGeralfEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player mills three cards. Exile up to two creature cards put into graveyards this way. Create an X/X blue Zombie creature token, where X is the total power of the cards exiled this way";
    }

    private StitcherGeralfEffect(StitcherGeralfEffect effect) {
        super((OneShotEffect)effect);
    }

    public StitcherGeralfEffect copy() {
        return new StitcherGeralfEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                cards.addAll((Collection)player.millCards(3, source, game));
            }
            cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.GRAVEYARD);
            TargetCard target = new TargetCard(0, 2, Zone.GRAVEYARD, (FilterCard)new FilterCreatureCard("creature cards to exile"));
            controller.chooseTarget(this.outcome, (Cards)cards, target, source, game);
            int power = 0;
            for (UUID cardId : target.getTargets()) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                power += card.getPower().getValue();
                controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
            }
            return new CreateTokenEffect((Token)new StitcherGeralfZombieToken(power)).apply(game, source);
        }
        return false;
    }
}

