/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class StolenStrategyEffect
extends OneShotEffect {
    StolenStrategyEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile the top card of each opponent's library. Until end of turn, you may cast nonland cards from among those exiled cards, and you may spend mana as though it were mana of any color to cast those spells";
    }

    private StolenStrategyEffect(StolenStrategyEffect effect) {
        super((OneShotEffect)effect);
    }

    public StolenStrategyEffect copy() {
        return new StolenStrategyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player damagedPlayer;
            if (!controller.hasOpponent(playerId, game) || (damagedPlayer = game.getPlayer(playerId)) == null) continue;
            MageObject sourceObject = game.getObject(source);
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            Card card = damagedPlayer.getLibrary().getFromTop(game);
            if (card == null || sourceObject == null) continue;
            controller.moveCardToExileWithInfo(card, exileId, sourceObject.getIdName(), source, game, Zone.LIBRARY, true);
            if (card.isLand(game) || card.getSpellAbility() == null) continue;
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }
}

