/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.s.StormHeraldAttachablePredicate;
import mage.cards.s.StormHeraldAttachableToPredicate;
import mage.cards.s.StormHeraldReplacementEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class StormHeraldEffect
extends OneShotEffect {
    StormHeraldEffect() {
        super(Outcome.Benefit);
        this.staticText = "return any number of Aura cards from your graveyard to the battlefield attached to creatures you control. Exile those Auras at the beginning of your next end step. If those Auras would leave the battlefield, exile them instead of putting them anywhere else";
    }

    private StormHeraldEffect(StormHeraldEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormHeraldEffect copy() {
        return new StormHeraldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            FilterCard filter = new FilterCard("aura cards to attach to creatures you control");
            filter.add((Predicate)SubType.AURA.getPredicate());
            filter.add((Predicate)new StormHeraldAttachablePredicate(controller.getId()));
            Set possibleTargets = controller.getGraveyard().getCards(filter, controller.getId(), source, game);
            if (!possibleTargets.isEmpty()) {
                TargetCard targetAuras = new TargetCard(0, Integer.MAX_VALUE, Zone.GRAVEYARD, filter);
                targetAuras.withNotTarget(true);
                controller.chooseTarget(this.outcome, (Cards)new CardsImpl(possibleTargets), targetAuras, source, game);
                ArrayList<Permanent> toExile = new ArrayList<Permanent>();
                for (UUID auraId : targetAuras.getTargets()) {
                    Permanent targetPermanent;
                    Card auraCard = game.getCard(auraId);
                    if (auraCard == null) continue;
                    FilterControlledCreaturePermanent filterAttachTo = new FilterControlledCreaturePermanent("creature you control to attach " + auraCard.getIdName() + " to");
                    filterAttachTo.add((Predicate)new StormHeraldAttachableToPredicate(auraCard));
                    TargetPermanent targetCreature = new TargetPermanent((FilterPermanent)filterAttachTo);
                    targetCreature.withNotTarget(true);
                    if (!controller.choose(Outcome.PutCardInPlay, (Target)targetCreature, source, game) || (targetPermanent = game.getPermanent(targetCreature.getFirstTarget())).cantBeAttachedBy((MageObject)auraCard, source, game, true)) continue;
                    game.getState().setValue("attachTo:" + auraCard.getId(), (Object)targetPermanent);
                    controller.moveCards(auraCard, Zone.BATTLEFIELD, source, game);
                    targetPermanent.addAttachment(auraCard.getId(), source, game);
                    Permanent permanent = game.getPermanent(auraId);
                    if (permanent == null) continue;
                    toExile.add(permanent);
                }
                StormHeraldReplacementEffect continuousEffect = new StormHeraldReplacementEffect();
                continuousEffect.setTargetPointer((TargetPointer)new FixedTargets(toExile, game));
                game.addEffect((ContinuousEffect)continuousEffect, source);
                ExileTargetEffect exileEffect = new ExileTargetEffect("exile those Auras");
                exileEffect.setTargetPointer((TargetPointer)new FixedTargets(toExile, game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect), source);
            }
            return true;
        }
        return false;
    }
}

