/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class StormHeraldReplacementEffect
extends ReplacementEffectImpl {
    StormHeraldReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = "If those Auras would leave the battlefield, exile them instead of putting them anywhere else";
    }

    private StormHeraldReplacementEffect(StormHeraldReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public StormHeraldReplacementEffect copy() {
        return new StormHeraldReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        ((ZoneChangeEvent)event).setToZone(Zone.EXILED);
        Permanent aura = ((ZoneChangeEvent)event).getTarget();
        MageObject sourceObject = source.getSourceObject(game);
        if (aura != null && sourceObject != null) {
            game.informPlayers(aura.getLogName() + "goes to exile instead (" + sourceObject.getLogName() + ")");
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && ((ZoneChangeEvent)event).getToZone() != Zone.EXILED && this.getTargetPointer().getTargets(game, source).contains(event.getTargetId());
    }
}

