/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.s.StormKingsThunderCopyEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class StormKingsThunderAbility
extends DelayedTriggeredAbility {
    StormKingsThunderAbility(int xValue) {
        super((Effect)new StormKingsThunderCopyEffect(xValue), Duration.EndOfTurn);
    }

    private StormKingsThunderAbility(StormKingsThunderAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public StormKingsThunderAbility copy() {
        return new StormKingsThunderAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        this.getEffects().setValue("spellCast", (Object)spell);
        return true;
    }

    public String getRule() {
        return "When you next cast an instant or sorcery spell this turn, copy that spell X times. You may choose new targets for the copies.";
    }
}

