/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StormbreathDragonDamageEffect
extends OneShotEffect {
    StormbreathDragonDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals damage to each opponent equal to the number of cards in that player's hand";
    }

    private StormbreathDragonDamageEffect(StormbreathDragonDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public StormbreathDragonDamageEffect copy() {
        return new StormbreathDragonDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            int damage;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || (damage = opponent.getHand().size()) <= 0) continue;
            opponent.damage(damage, source.getSourceId(), source, game);
        }
        return true;
    }
}

