/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeSacrificedPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class StranglingGraspEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("nonland permanent you control");

    StranglingGraspEffect() {
        super(Outcome.Benefit);
        this.staticText = "enchanted permanent's controller sacrifices a nonland permanent, then that player loses 1 life";
    }

    private StranglingGraspEffect(StranglingGraspEffect effect) {
        super((OneShotEffect)effect);
    }

    public StranglingGraspEffect copy() {
        return new StranglingGraspEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanentOrLKIBattlefield(arg_0)).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).orElse(null);
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        if (target.canChoose(player.getId(), source, game)) {
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.sacrifice(source, game);
            }
        }
        player.loseLife(1, game, source, false);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)CanBeSacrificedPredicate.instance);
    }
}

