/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class StraxSontaranNurseEffect
extends OneShotEffect {
    StraxSontaranNurseEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a player at random. When you do, {this} fights another target creature that player controls";
    }

    private StraxSontaranNurseEffect(StraxSontaranNurseEffect effect) {
        super((OneShotEffect)effect);
    }

    public StraxSontaranNurseEffect copy() {
        return new StraxSontaranNurseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer((UUID)RandomUtil.randomFromCollection((Collection)game.getState().getPlayersInRange(source.getControllerId(), game, true)));
        if (player == null) {
            return false;
        }
        game.informPlayers(player.getLogName() + " has been chosen at random");
        FilterCreaturePermanent filter = new FilterCreaturePermanent("another creature controlled by " + player.getName());
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new FightTargetSourceEffect(), false);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

