/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class StreamOfThoughtEffect
extends OneShotEffect {
    StreamOfThoughtEffect() {
        super(Outcome.Benefit);
        this.staticText = "You shuffle up to four cards from your graveyard into your library.";
    }

    private StreamOfThoughtEffect(StreamOfThoughtEffect effect) {
        super((OneShotEffect)effect);
    }

    public StreamOfThoughtEffect copy() {
        return new StreamOfThoughtEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 4);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            return false;
        }
        player.shuffleCardsToLibrary((Cards)new CardsImpl((Collection)target.getTargets()), game, source);
        return true;
    }
}

