/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class StreetSweeperDestroyEffect
extends OneShotEffect {
    public StreetSweeperDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all Auras attached to target land";
    }

    private StreetSweeperDestroyEffect(StreetSweeperDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public StreetSweeperDestroyEffect copy() {
        return new StreetSweeperDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            LinkedList attachments = new LinkedList();
            attachments.addAll(permanent.getAttachments());
            for (UUID uuid : attachments) {
                Permanent aura = game.getPermanent(uuid);
                if (aura == null || !aura.hasSubtype(SubType.AURA, game)) continue;
                aura.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

