/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

enum StrefanMaurerProgenitorNumberPlayersLostLifeDynamicValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller == null) {
            return 0;
        }
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        int numPlayersWhoLostLife = 0;
        if (watcher != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                if (watcher.getLifeLost(playerId) <= 0) continue;
                ++numPlayersWhoLostLife;
            }
        }
        return numPlayersWhoLostLife;
    }

    public DynamicValue copy() {
        return instance;
    }

    public String getMessage() {
        return "player who lost life this turn";
    }

    public String toString() {
        return "1";
    }
}

