/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class StrengthTestingHammerEffect
extends OneShotEffect {
    StrengthTestingHammerEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. That creature gets +X/+0 until end of turn, where X is the result.";
    }

    private StrengthTestingHammerEffect(StrengthTestingHammerEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrengthTestingHammerEffect copy() {
        return new StrengthTestingHammerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int result = player.rollDice(this.outcome, source, game, 6);
            game.addEffect((ContinuousEffect)new BoostEquippedEffect(result, 0, Duration.EndOfTurn), source);
        }
        return false;
    }
}

