/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class StringOfDisappearancesEffect
extends OneShotEffect {
    StringOfDisappearancesEffect() {
        super(Outcome.Damage);
        this.staticText = "Return target creature to its owner's hand. Then that creature's controller may pay {U}{U}. If the player does, they may copy this spell and may choose a new target for that copy.";
    }

    private StringOfDisappearancesEffect(StringOfDisappearancesEffect effect) {
        super((OneShotEffect)effect);
    }

    public StringOfDisappearancesEffect copy() {
        return new StringOfDisappearancesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        Player affectedPlayer = game.getPlayer(permanent.getControllerId());
        new ReturnToHandTargetEffect().apply(game, source);
        if (affectedPlayer == null) {
            return false;
        }
        if (!affectedPlayer.chooseUse(Outcome.Copy, "Pay {U}{U} to copy the spell?", source, game)) {
            return true;
        }
        ManaCostsImpl cost = new ManaCostsImpl("{U}{U}");
        if (!cost.pay(source, game, source, affectedPlayer.getId(), false, null)) {
            return true;
        }
        Spell spell = game.getStack().getSpell(source.getSourceId());
        if (spell == null) {
            return true;
        }
        spell.createCopyOnStack(game, source, affectedPlayer.getId(), true);
        return true;
    }
}

