/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class StrongarmTacticsEffect
extends OneShotEffect {
    StrongarmTacticsEffect() {
        super(Outcome.Discard);
        this.staticText = "Each player discards a card. Then each player who didn't discard a creature card this way loses 4 life.";
    }

    private StrongarmTacticsEffect(StrongarmTacticsEffect effect) {
        super((OneShotEffect)effect);
    }

    public StrongarmTacticsEffect copy() {
        return new StrongarmTacticsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        if (controller != null) {
            Player player;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                int numberOfCardsToDiscard = Math.min(1, player.getHand().size());
                TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, new FilterCard(), playerId);
                player.chooseTarget(this.outcome, (Target)target, source, game);
                CardsImpl cards = new CardsImpl();
                cards.addAll((Collection)target.getTargets());
                cardsToDiscard.put(playerId, cards);
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Cards cardsPlayer;
                player = game.getPlayer(playerId);
                if (player == null || (cardsPlayer = (Cards)cardsToDiscard.get(playerId)) == null) continue;
                for (UUID cardId : cardsPlayer) {
                    Card card = game.getCard(cardId);
                    if (card == null || player.discard(card, false, source, game) && card.isCreature(game)) continue;
                    player.loseLife(4, game, source, false);
                }
            }
        }
        return true;
    }
}

