/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SubterraneanTremorsLizardToken;
import mage.util.CardUtil;

class SubterraneanTremorsEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filterCreatures = new FilterCreaturePermanent("creature without flying");
    private static final FilterArtifactPermanent filterArtifacts = new FilterArtifactPermanent("all artifacts");

    public SubterraneanTremorsEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to each creature without flying. If X is 4 or more, destroy all artifacts. If X is 8 or more, create an 8/8 red Lizard creature token.";
    }

    private SubterraneanTremorsEffect(SubterraneanTremorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SubterraneanTremorsEffect copy() {
        return new SubterraneanTremorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        UUID sourceId = source != null ? source.getSourceId() : null;
        UUID controllerId = source.getControllerId();
        List creaturePermanents = game.getBattlefield().getActivePermanents((FilterPermanent)filterCreatures, controllerId, game);
        for (Permanent permanent : creaturePermanents) {
            permanent.damage(damage, sourceId, source, game, false, true);
        }
        if (damage >= 4) {
            List artifactPermanents = game.getBattlefield().getActivePermanents((FilterPermanent)filterArtifacts, controllerId, game);
            for (Permanent permanent : artifactPermanents) {
                permanent.destroy(source, game, false);
            }
        }
        if (damage >= 8) {
            SubterraneanTremorsLizardToken lizardToken = new SubterraneanTremorsLizardToken();
            lizardToken.putOntoBattlefield(1, game, source, controllerId);
        }
        return true;
    }

    static {
        filterCreatures.add(Predicates.not((Predicate)new AbilityPredicate(FlyingAbility.class)));
    }
}

