/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class SuddenDemiseDamageEffect
extends OneShotEffect {
    SuddenDemiseDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose a color. {this} deals X damage to each creature of the chosen color";
    }

    private SuddenDemiseDamageEffect(SuddenDemiseDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public SuddenDemiseDamageEffect copy() {
        return new SuddenDemiseDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && controller.choose(this.outcome, (Choice)choice, game)) {
            int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                permanent.damage(damage, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

