/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class SummonEsperValigarmandaExileEffect
extends OneShotEffect {
    SummonEsperValigarmandaExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile an instant or sorcery card from each graveyard";
    }

    private SummonEsperValigarmandaExileEffect(SummonEsperValigarmandaExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonEsperValigarmandaExileEffect copy() {
        return new SummonEsperValigarmandaExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        target.withNotTarget(true);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game) < 1) continue;
            target.clearChosen();
            controller.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
            cards.add(game.getCard(target.getFirstTarget()));
        }
        return !cards.isEmpty() && controller.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source, (int)1), CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

