/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseExpansionSetEffect;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.cards.Card;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class SummonThePackEffect
extends OneShotEffect {
    SummonThePackEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Open a sealed Magic booster pack, reveal the cards, and put all creature cards revealed this way onto the battlefield under your control. They're Zombies in addition to their other types";
    }

    private SummonThePackEffect(SummonThePackEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonThePackEffect copy() {
        return new SummonThePackEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ExpansionSet expansionSet;
        ChooseExpansionSetEffect effect = new ChooseExpansionSetEffect(Outcome.UnboostCreature);
        effect.apply(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        String setChosen = null;
        if (effect.getValue("setchosen") != null) {
            setChosen = (String)effect.getValue("setchosen");
        } else if (game.getState().getValue(this.getId() + "_set") != null) {
            setChosen = (String)game.getState().getValue(this.getId() + "_set");
        }
        if (setChosen != null && controller != null && (expansionSet = Sets.findSet((String)setChosen)) != null) {
            List boosterPack = expansionSet.create15CardBooster();
            ArrayList<Card> creatureCards = new ArrayList<Card>();
            if (boosterPack != null) {
                StringBuilder message = new StringBuilder(controller.getLogName()).append(" opened: ");
                for (Card c : boosterPack) {
                    if (c == null || !c.isCreature(game)) continue;
                    message.append(c.getName()).append(" ");
                    message.append(" (creature card) ");
                    AddCreatureTypeAdditionEffect effect2 = new AddCreatureTypeAdditionEffect(SubType.ZOMBIE, false);
                    effect2.setTargetPointer((TargetPointer)new FixedTarget(c.getId()));
                    game.addEffect((ContinuousEffect)effect2, source);
                    creatureCards.add(c);
                    c.setZone(Zone.OUTSIDE, game);
                }
                if (creatureCards.size() > 0) {
                    HashSet ccs = new HashSet(creatureCards);
                    game.loadCards(ccs, controller.getId());
                    controller.moveCards(ccs, Zone.BATTLEFIELD, source, game);
                }
                game.informPlayers(message.toString());
            }
        }
        return false;
    }
}

