/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.s;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class SummonValeforEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creature you control with the greatest mana value");

    SummonValeforEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent chooses a creature with the greatest mana value among creatures they control. Return those creatures to their owners' hands";
    }

    private SummonValeforEffect(SummonValeforEffect effect) {
        super((OneShotEffect)effect);
    }

    public SummonValeforEffect copy() {
        return new SummonValeforEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player2 = game.getPlayer(opponentId);
            if (player2 == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, opponentId, source, game, 1)) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player2.choose(Outcome.ReturnToHand, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
        }
        permanents.removeIf(Objects::isNull);
        if (permanents.isEmpty()) {
            return false;
        }
        Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.moveCards(permanents, Zone.HAND, source, game));
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)SummonValeforPredicate.instance);
    }

    static enum SummonValeforPredicate implements ObjectSourcePlayerPredicate<Permanent>
    {
        instance;


        public boolean apply(ObjectSourcePlayer<Permanent> input, Game game) {
            return ((Permanent)input.getObject()).getManaValue() >= game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, input.getPlayerId(), input.getSource(), game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
        }
    }
}

